# Figure 1 - source code 1. 
Lambda_ss, Lambda_over = (12, 21)
L0 = 1

import numpy as np
import matplotlib.pyplot as plt
import matplotlib as mpl
import math 
from scipy import interpolate
import cv2

grid = plt.GridSpec(6, 4, wspace=0.6, hspace=0.7)

x = np.linspace(0, 30, 1000)

# Full dose
y_SS = L0*np.exp(-x/Lambda_ss)
y_over = L0*np.exp(-x/Lambda_over)

xdy_SS = interpolate.interp1d(y_SS, x)
x_col = xdy_SS(L0/4)

xdy_over = interpolate.interp1d(y_over, x)
x_dpp_over = xdy_over(L0/4)

Th_dy_SS = interpolate.interp1d(x, y_SS)
T_dpp_SS = Th_dy_SS(x_dpp_over)

x_dpp_SS = xdy_SS(T_dpp_SS)

# half dosage

y_SS_05 = 0.5*L0*np.exp(-x/Lambda_ss)
y_over_05 = 0.5*L0*np.exp(-x/Lambda_over)

xdy_SS_05 = interpolate.interp1d(y_SS_05, x)
x_col_05 = xdy_SS_05(L0/4)

xdy_over_05 = interpolate.interp1d(y_over_05, x)
x_dpp_over_05 = xdy_over_05(L0/4)

Th_dy_SS_05 = interpolate.interp1d(x, y_SS_05)
T_dpp_SS_05 = Th_dy_SS_05(x_dpp_over_05)

x_dpp_SS_05 = xdy_SS_05(T_dpp_SS)


plt.figure(figsize = (7, 10))


plt.subplot(grid[3, 0:2])
plt.plot([0, x[-1]], [L0/4, L0/4],  "--", linewidth = 0.9, c = "tab:purple")
plt.plot([0, x[-1]], [T_dpp_SS, T_dpp_SS], "--", linewidth = 0.9, c = "tab:purple")
plt.plot(x,y_SS, c = "k")
plt.plot([x_col, x_col], [-0.05,L0/4], c = "lime", label = "col")
plt.plot([x_dpp_over, x_dpp_over], [-0.05,T_dpp_SS], c = "r", label = "dpp")
plt.ylabel("[Hh]", fontsize=12)
plt.title("Steady-state \n (two thresholds)", fontsize=12)
plt.ylim(-0.05,1)
plt.legend(fontsize = 10, frameon=False)
plt.text(4, 0.8, "WT", fontsize=12)

plt.subplot(grid[4, 0:2])
plt.plot([0, x[-1]], [L0/4, L0/4],  "--", linewidth = 0.9, c = "tab:purple")
plt.plot([0, x[-1]], [T_dpp_SS, T_dpp_SS], "--", linewidth = 0.9, c = "tab:purple")
plt.plot(x,y_SS_05, c = "k", label = "real SS")
plt.plot([x_col_05, x_col_05], [-0.05,L0/4], c = "lime")
plt.plot([x_dpp_SS_05, x_dpp_SS_05], [-0.05,T_dpp_SS], c = "r")
plt.ylabel("[Hh]", fontsize=12)

plt.text(4, 0.8, "Hh half dose", fontsize=12)
plt.ylim(-0.05,1)



plt.subplot(grid[5, 0:2])
line = 0.2
h = 0.03
plt.plot([x_col_05, x_col], [line + 8*h, line + 8*h], c = "lime")
plt.plot([x_col_05, x_col_05], [line + 8*h -h, line+8*h+h], c = "lime")
plt.plot([x_col, x_col], [line + 8*h -h, line + 8*h +h], c = "lime")

plt.plot([x_dpp_SS_05, x_dpp_SS], [line, line], c = "r")
plt.plot([x_dpp_SS,x_dpp_SS], [line-h, line+h], c = "r")
plt.plot([x_dpp_SS_05, x_dpp_SS_05], [line-h, line+h], c = "r")
plt.xlabel(r"$x \ (\mu  m)$", fontsize = 12)
plt.text(14.5, 0.58, "$\Delta x$", fontsize = 12)
plt.text(x_col_05 + 1 , 0.47, str(round(x_col - x_col_05, 2)), fontsize=12)  
plt.text(x_dpp_SS_05 + 1, 0.23, str(round(x_dpp_SS - x_dpp_SS_05,2)), fontsize=12) 
plt.gca().get_yaxis().set_visible(False)
plt.ylim(0.1,0.7)
plt.xlim(x[0], x[-1])



plt.subplot(grid[3, 2:4])
plt.plot([0,x[-1]], [L0/4, L0/4],  "--", linewidth = 0.9, c = "tab:purple")
plt.plot(x,y_SS, c = "k", label = "Steady-State")
plt.plot(x,y_over, "--" , c = "k", label = "Overshoot")
plt.plot([x_col, x_col], [-0.05,L0/4], c = "lime")
plt.plot([x_dpp_over, x_dpp_over], [-0.05,L0/4], c = "r")
#plt.ylabel("[Hh]", fontsize=12)
plt.title("Dynamical interpretation \n (single threshold)", fontsize=12)

plt.legend(fontsize = 8,frameon=False)
plt.ylim(-0.05,1)


plt.subplot(grid[4, 2:4])
plt.plot([0,x[-1]], [L0/4, L0/4],  "--", linewidth = 0.9, c = "tab:purple")
plt.plot(x,y_SS_05, c = "k", label = "real SS")
plt.plot(x,y_over_05, "--" , c = "k")
plt.plot([x_col_05, x_col_05], [-0.05,L0/4], c = "lime")
plt.plot([x_dpp_over_05, x_dpp_over_05], [-0.05,L0/4], c = "r")
plt.ylim(0,1)
#plt.ylabel("[Hh]", fontsize=12)
#plt.text(1.5, 0.7, "Perturbed")
plt.ylim(-0.05,1)

plt.subplot(grid[5, 2:4])
line = 0.2
h = 0.03
plt.plot([x_col_05, x_col], [line + 8*h, line+ 8*h], c = "lime")
plt.plot([x_col_05, x_col_05], [line+ 8*h -h, line+ 8*h +h], c = "lime")
plt.plot([x_col, x_col], [line+ 8*h -h, line+ 8*h +h], c = "lime")

plt.plot([x_dpp_over_05, x_dpp_over], [line, line], c = "r")
plt.plot([x_dpp_over, x_dpp_over], [line-h, line+h], c = "r")
plt.plot([x_dpp_over_05, x_dpp_over_05], [line-h, line+h], c = "r")
plt.xlabel(r"$x \ (\mu m)$", fontsize = 12)
plt.xlim(x[0], x[-1])
plt.ylim(0.1,0.7)
#plt.text(14.5, 0.73, "$\Delta x$", fontsize = 12)
plt.text(x_col_05 + 1, 0.47, str(round(x_col - x_col_05,2)), fontsize=12)
plt.text(x_dpp_over_05 + 3, 0.23, str(round( x_dpp_over - x_dpp_over_05,2)), fontsize=12) #str(round( x_dpp_over - x_dpp_over_05,2))) 
plt.gca().get_yaxis().set_visible(False)
plt.ylim(0.1,0.7)


# alphabetical order
#plt.text(-40, 5.7, "A", fontsize = 14, weight='bold')
plt.text(-40, 2.9, "b", fontsize = 14, weight='bold')
plt.text(-4, 2.9, "b'", fontsize = 14, weight='bold')
plt.text(-40, 1.85, "c", fontsize = 14, weight='bold')
plt.text(-4, 1.85, "c'", fontsize = 14, weight='bold')
plt.text(-40, 0.75, "d", fontsize = 14, weight='bold')
plt.text(-4, 0.75, "d'", fontsize = 14, weight='bold')
#plt.savefig("figure1.png", dpi = 512, bbox_inches = "tight")
plt.show()
